#ifndef __MATH_H
#define __MATH_H

#include "stddef.h" // Для size_t и NULL
#include "stdint.h" // Для int32_t

/* Типы для классификации чисел с плавающей точкой */
#define FP_INFINITE  1
#define FP_NAN       2
#define FP_NORMAL    3
#define FP_SUBNORMAL 4
#define FP_ZERO      5

/* Макросы для бесконечности и NaN */
#define INFINITY (__builtin_inff())
#define NAN      (__builtin_nanf(""))

/* Макросы для представления больших значений */
#define HUGE_VALF (__builtin_inff())
#define HUGE_VAL  ((double)__builtin_inff())
#define HUGE_VALL ((long double)__builtin_inff())

/* Математические константы (необязательны в C99, но полезны) */
#define M_E        2.71828182845904523536
#define M_LOG2E    1.44269504088896340736
#define M_LOG10E   0.43429448190325182765
#define M_LN2      0.69314718055994530942
#define M_LN10     2.30258509299404568402
#define M_PI       3.14159265358979323846
#define M_PI_2     1.57079632679489661923
#define M_PI_4     0.78539816339744830962
#define M_1_PI     0.31830988618379067154
#define M_2_PI     0.63661977236758134308
#define M_2_SQRTPI 1.12837916709551257390
#define M_SQRT2    1.41421356237309504880
#define M_SQRT1_2  0.70710678118654752440

/* Функции для float */
float acosf(float x);
float asinf(float x);
float atanf(float x);
float atan2f(float y, float x);
float cosf(float x);
float sinf(float x);
float tanf(float x);
float acoshf(float x);
float asinhf(float x);
float atanhf(float x);
float expf(float x);
float logf(float x);
float log10f(float x);
float powf(float x, float y);
float sqrtf(float x);
float ceilf(float x);
float floorf(float x);
float fmodf(float x, float y);
float roundf(float x);
float truncf(float x);
float fmaf(float x, float y, float z);
float fabsf(float x);
float fmaxf(float x, float y);
float fminf(float x, float y);

/* Функции для double */
double acos(double x);
double asin(double x);
double atan(double x);
double atan2(double y, double x);
double cos(double x);
double sin(double x);
double tan(double x);
double acosh(double x);
double asinh(double x);
double atanh(double x);
double exp(double x);
double log(double x);
double log10(double x);
double pow(double x, double y);
double sqrt(double x);
double ceil(double x);
double floor(double x);
double fmod(double x, double y);
double round(double x);
double trunc(double x);
double fma(double x, double y, double z);
double fabs(double x);
double fmax(double x, double y);
double fmax(double x, double y);

/* Функции для long double */
/*
long double acosl(long double x);
long double asinl(long double x);
long double atanl(long double x);
long double atan2l(long double y, long double x);
long double cosl(long double x);
long double sinl(long double x);
long double tanl(long double x);
long double acoshl(long double x);
long double asinhl(long double x);
long double atanhl(long double x);
long double expl(long double x);
long double logl(long double x);
long double log10l(long double x);
long double powl(long double x, long double y);
long double sqrtl(long double x);
long double ceill(long double x);
long double floorl(long double x);
long double fmodl(long double x, long double y);
long double roundl(long double x);
long double truncl(long double x);
long double fmal(long double x, long double y, long double z);
long double fabsl(long double x);
long double fmaxl(long double x, long double y);
long double fminl(long double x, long double y);
*/

/* Функции классификации и сравнения */
int fpclassify(float x);
int isfinite(float x);
//int isinf(float x);
//int isnan(float x);
int isnormal(float x);
int signbit(float x);

#endif