#ifndef __STDDEF_H
#define __STDDEF_H

// Тип size_t: беззнаковый целый тип для размеров объектов 
typedef unsigned int size_t;

// Тип ptrdiff_t: знаковый целый тип для разницы указателей 
typedef int ptrdiff_t;

// Тип wchar_t: 16-битный целый тип для широких символов (-fshort-wchar) 
typedef unsigned short wchar_t;

// Макрос NULL: пустой указатель 
#ifndef NULL
#define NULL ((void *)0)
#endif

// Макрос offsetof: вычисляет смещение поля в структуре 
#define offsetof(type, member) ((size_t) &((type *)0)->member)

#endif