#ifndef __STDIO_H
#define __STDIO_H

#include <stdarg.h>

typedef unsigned int size_t;


// ### Форматированный вывод на стандартный поток (stdout)
// Выводит форматированную строку на стандартный вывод (stdout)
int printf(const char *format, ...);
// Аналог printf, но принимает список аргументов va_list для форматированного вывода
int vprintf(const char *format, va_list arg);

// ### Форматированный ввод со стандартного потока (stdin)
// Считывает форматированный ввод со стандартного ввода (stdin)
// int scanf(const char *format, ...);
// Аналог scanf, но использует va_list
// int vscanf(const char *format, va_list arg);

// ### Форматирование строк (без вывода в поток)
// Форматирует строку и записывает её в буфер str
int sprintf(char *str, const char *format, ...);
// Форматирует строку, записывая не более size символов в str (безопасная версия sprintf)
int snprintf(char *str, size_t size, const char *format, ...);
// Аналог sprintf, но с va_list
int vsprintf(char *str, const char *format, va_list arg);
// Аналог snprintf, но с va_list
int vsnprintf(char *str, size_t size, const char *format, va_list arg);


// ### Символьный ввод/вывод на стандартный поток
// Считывает один символ со стандартного ввода (stdin)
// int getchar(void);
// Выводит один символ на стандартный вывод (stdout)
int putchar(int c);
// Выводит строку s на stdout, добавляя символ новой строки (\n)
int puts(const char *s);


#endif