#ifndef __STDLIB_H
#define __STDLIB_H

#include "stddef.h" // Для size_t и wchar_t
#include "stdint.h" // Для intN_t, uintN_t

/* Типы для функций div */
typedef struct {
    int quot; // Частное
    int rem;  // Остаток
} div_t;

typedef struct {
    long quot;
    long rem;
} ldiv_t;

typedef struct {
    long long quot;
    long long rem;
} lldiv_t;

/* Макросы */
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#define RAND_MAX 32767 // Стандартное значение для rand
#define MB_CUR_MAX 2   // Учитывает -fshort-wchar (2 байта для wchar_t)

/* Функции управления памятью */
void *malloc(size_t size);
void *calloc(size_t nmemb, size_t size);
void *realloc(void *ptr, size_t size);
void free(void *ptr);

/* Преобразование строк в числа */
int atoi(const char *nptr);
long atol(const char *nptr);
long long atoll(const char *nptr);
double atof(const char *nptr);
long strtol(const char *nptr, char **endptr, int base);
long long strtoll(const char *nptr, char **endptr, int base);
unsigned long strtoul(const char *nptr, char **endptr, int base);
unsigned long long strtoull(const char *nptr, char **endptr, int base);
float strtof(const char *nptr, char **endptr);
double strtod(const char *nptr, char **endptr);
long double strtold(const char *nptr, char **endptr);

/* Генерация случайных чисел */
int rand(void);
void srand(unsigned int seed);

/* Арифметические функции */
int abs(int j);
long labs(long j);
long long llabs(long long j);
div_t div(int numer, int denom);
ldiv_t ldiv(long numer, long denom);
lldiv_t lldiv(long long numer, long long denom);

/* Функции завершения программы */
void abort(void);
void exit(int status);
//void _Exit(int status);
int atexit(void (*func)(void));

/* Поиск и сортировка */
void *bsearch(const void *key, const void *base, size_t nmemb, size_t size, int (*compar)(const void *, const void *));
void qsort(void *base, size_t nmemb, size_t size, int (*compar)(const void *, const void *));

#endif