#ifndef __STRING_H
#define __STRING_H

typedef unsigned int size_t;

// ### Копирование строк
// Копирует строку src (включая \0) в dest
char *strcpy(char *dest, const char *src);
// Копирует не более n символов из src в dest, дополняя \0
char *strncpy(char *dest, const char *src, size_t n);
// Добавляет строку src к концу строки dest
char *strcat(char *dest, const char *src);
// Добавляет не более n символов из src к dest
char *strncat(char *dest, const char *src, size_t n);

// ### Сравнение строк
// Cравнивает строки s1 и s2
int strcmp(const char *s1, const char *s2);
// Сравнивает не более n символов строк s1 и s2
int strncmp(const char *s1, const char *s2, size_t n);

// ### Поиск в строках
// Ищет первое вхождение символа c в строке s
char *strchr(const char *s, int c);
// Ищет последнее вхождение символа c в строке s
char *strrchr(const char *s, int c);
// Ищет первое вхождение подстроки needle в haystack
char *strstr(const char *haystack, const char *needle);
// Ищет первый символ в s, совпадающий с любым из accept
char *strpbrk(const char *s, const char *accept);
// Возвращает длину начального сегмента строки s, состоящего из символов accept
size_t strspn(const char *s, const char *accept);
// Возвращает длину начального сегмента строки s, не содержащего символы из reject
size_t strcspn(const char *s, const char *reject);
// Разбивает строку s на токены по разделителям delim
char *strtok(char *s, const char *delim);

// ### Длина строки
// Возвращает длину строки s (без \0)
size_t strlen(const char *s);


// ### Работа с памятью
// Копирует n байт из src в dest
void *memcpy(void *dest, const void *src, size_t n);
// Копирует n байт из src в dest, корректно обрабатывая перекрытие
void *memmove(void *dest, const void *src, size_t n);
// Заполняет n байт памяти, начиная с s, значением c
void *memset(void *s, int c, size_t n);
// Сравнивает первые n байт двух областей памяти
int memcmp(const void *s1, const void *s2, size_t n);
// Ищет первое вхождение байта c в первых n байтах s
void *memchr(const void *s, int c, size_t n);

#endif