#ifndef __TIME_H
#define __TIME_H

#include "stddef.h" // Для size_t и NULL
#include "stdint.h" // Для int32_t, uint32_t

/* Типы */
typedef uint32_t clock_t; // Процессорное время (32 бита для Cortex-M4)
typedef uint32_t time_t;  // Календарное время (32 бита, достаточен для большинства bare-metal систем)

struct tm {
    int tm_sec;   /* секунды: 0-59 */
    int tm_min;   /* минуты: 0-59 */
    int tm_hour;  /* часы: 0-23 */
    int tm_mday;  /* день месяца: 1-31 */
    int tm_mon;   /* месяц: 0-11 */
    int tm_year;  /* год минус 1900 */
    int tm_wday;  /* день недели: 0-6 (воскресенье = 0) */
    int tm_yday;  /* день в году: 0-365 */
    int tm_isdst; /* флаг летнего времени: 0 (нет), >0 (да), <0 (неизвестно) */
};

/* Макросы */
#define CLOCKS_PER_SEC 168000000
#define CLOCKS_PER_MS  168000
#define CLOCKS_PER_MKS 168


/* Функции */
//clock_t clock(void);
#define clock()        (*(volatile clock_t *)0xE0001004)
time_t time(time_t *timer);
double difftime(time_t time1, time_t time0);
time_t mktime(struct tm *tm);
struct tm *gmtime(const time_t *timer);
struct tm *localtime(const time_t *timer);
char *asctime(const struct tm *tm);
char *ctime(const time_t *timer);
size_t strftime(char *s, size_t max, const char *format, const struct tm *tm);

#endif